{**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* @author    Presta.Site
* @copyright 2016 Presta.Site
* @license   LICENSE.txt
*}
<div id="ttpc-countdowns-list">
    <div class="panel">
        <div class="panel-heading">
            <i class="icon-cogs"></i> {l s='Countdown list' mod='ttproductcountdown'}
        </div>
        <div class="form-wrapper">
            <div class="form-group">
                <div class="table-responsive-row">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>{l s='Product' mod='ttproductcountdown'}</th>
                            <th>{l s='Name' mod='ttproductcountdown'}</th>
                            <th>{l s='From' mod='ttproductcountdown'}</th>
                            <th>{l s='To' mod='ttproductcountdown'}</th>
                            <th>{l s='State' mod='ttproductcountdown'}</th>
                            <th>{l s='Actions' mod='ttproductcountdown'}</th>
                        </tr>
                        </thead>
                        <tbody>
                        {foreach from=$countdowns item=countdown}
                            <tr>
                                <td>#{$countdown.id_product|intval} {$countdown.product_name|escape:'html':'UTF-8'}</td>
                                <td>{$countdown.name|escape:'html':'UTF-8'}</td>
                                <td>{$countdown.from|escape:'html':'UTF-8'}</td>
                                <td>{$countdown.to|escape:'html':'UTF-8'}</td>
                                <td>
                                    {if !$countdown.expired}
                                        {if $countdown.active}
                                            <span class="label label-success">{l s='Enabled' mod='ttproductcountdown'}</span>
                                        {else}
                                            <span class="label label-danger">{l s='Disabled' mod='ttproductcountdown'}</span>
                                        {/if}
                                    {else}
                                        <span class="label label-default">{l s='Inactive' mod='ttproductcountdown'}</span>
                                    {/if}
                                </td>
                                <td>
                                    {* Edit btn *}
                                    <a href="{$product_link|escape:'html':'UTF-8'}&id_product={$countdown.id_product|intval}&updateproduct&key_tab={$key_tab|escape:'html':'UTF-8'}"
                                       title="{l s='Edit' mod='ttproductcountdown'}" class="edit btn btn-default" target="_blank">
                                        <i class="icon-pencil"></i>
                                    </a>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    {* Remove btn *}
                                    <a href="#" title="{l s='Remove' mod='ttproductcountdown'}" class="edit btn btn-default remove-countdown" data-id-countdown="{$countdown.id_countdown|intval}">
                                        <i class="icon-remove"></i>
                                    </a>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var ttpc_ajax_url = "{$ajax_url|escape:'quotes':'UTF-8'}";
        var ttpc_remove_confirm_txt = "{l s='Are you sure you want to delete this countdown?' mod='ttproductcountdown'}";
    </script>
</div>
