import { OAuth2PopupFlow } from 'oauth2-popup-flow';

$(document).on('ready', function(){

    const $connectButton = $('#connect_pulse');
    const $disconnectButton = $('#disconnect_pulse');
    const pulsehostname = $('#_PULSE_HOSTNAME').val().toString();
    const pulseclientid = $('#_PULSE_CLIENT_ID').val().toString();
    const redirecturi = $('#_PULSE_REDIRECT_URI').val().toString();
    const scopes = $('#_PULSE_SCOPES').val().toString();

// create a type for the payload of the token
    interface TokenPayload {
        exp: number;
        state: string;
        username: string;
        access_token: string;
    }

// create an instance of `OAuth2PopupFlow`
    const auth = new OAuth2PopupFlow<TokenPayload>({
        authorizationUri: $connectButton.attr('href'),
        clientId: pulseclientid,
        redirectUri: redirecturi,
        scope: scopes,
        responseType: 'code',
        additionalAuthorizationParameters: () => {
            // in prod, consider something more cryptographic
            const state = Math.floor(Math.random() * 1000).toString();
            localStorage.setItem('state', state);
            return { state };
            // `state` will now be encoded in the URL like so:
            // https://example.com/oauth/authorize?client_id=foo_client...nonce=1234
        },
        afterResponse: ((authorizationResponse: {}) => {
            console.log(authorizationResponse);
        })
    });

// opens the login popup
// if the user is already logged in, it won't open the popup
    /*auth.tryLoginPopup().then((result: string) => {
        if (result === 'ALREADY_LOGGED_IN') {
            // ...
        } else if (result === 'POPUP_FAILED') {
            // ...
        } else if (result === 'SUCCESS') {
            // ...
        }
    });*/

// synchronously returns whether or not the user is logged in
    const loggedIn = auth.loggedIn();

    async function openOauthTab() {
        // open the popup
        await auth.tryLoginPopup();
    }

    async function getInfoFromToken() {
        // open the popup
        auth.tryLoginPopup();
        // returns the decoded payload of the token when authorized
        const payload = await auth.tokenPayload();
        return payload.username;
    }

    auth.logout();
    $connectButton.on('click', async (e) => {
        e.preventDefault();
        await openOauthTab();
    });

    $disconnectButton.on('click', async (e) => {
        e.preventDefault();
        $.ajax($disconnectButton.attr('href'), {
            success: function (response) {
                location.reload()
            }
        })
    });

    window.addEventListener("message", (event) => {
        if (event.data.result.success == true) {
            location.reload();
        }
    }, false);

});