import { OAuth2PopupFlow } from 'oauth2-popup-flow';

$(document).on('ready', function () {

    const button = document.querySelector('#connect_pulse')
    const content = document.querySelector('.content');

    const auth = new OAuth2PopupFlow({
        authorizationUri: 'http://utixomailer.local/authorize',
        clientId: 'auth_client',
        redirectUri: 'http://prestashop.local/en/module/pulseps/oauth',
        scope: ['contacts.read'],
        responseType: 'code',
        accessTokenResponseKey: 'id_token',
        additionalAuthorizationParameters: {
            nonce: Math.random().toString(),
        }
    });

    async function main() {
        content.innerHTML = '';
        if (auth.loggedIn()) {
            const payload = await auth.tokenPayload();
            content.innerText = `Welcome, ${payload.name}!`;
            const logoutButton = document.createElement('button');
            logoutButton.innerText = 'Logout';
            logoutButton.addEventListener('click', () => {
                auth.logout();
                main();
            });
            content.appendChild(logoutButton);
        } else {
            const loginButton = document.createElement('button');
            loginButton.innerText = 'Login';
            button.addEventListener('click', async (e) => {
                e.preventDefault();
                await auth.tryLoginPopup();
                main();
            });
            /*loginButton.addEventListener('click', async () => {
                await auth.tryLoginPopup();
                main();
            });
            content.appendChild(loginButton);*/
        }
    }

    main();
});
