{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*}

<div class="panel">
    <div class="panel-heading">
        <i class="icon-truck"></i>
        {l s='Gestione Account' mod='posteitaliane'}
    </div>
    <div class="tab-content text-center">     
        <h4>I tuoi servizi</h4>
        <table class="table table-bordered text-left" style="max-width: 350px; margin:20px auto">
            <thead><tr><th>Corriere</th><th>Servizio</th><th>Postazione</th><th>Elimina</th></tr></thead>
            <tbody>
                {foreach $carriers as $carrier}
                    <tr carrier-name="{$carrier->CarrierName|escape:'html':'utf-8'}" carrier-id="{$carrier->CarrierID|escape:'html':'utf-8'}"><td>{$carrier->CarrierName|escape:'html':'utf-8'}</td><td>{$carrier->CarrierService|escape:'html':'utf-8'}</td><td>{$carrier->Credentials->postazione|escape:'html':'utf-8'}</td><td style="text-align: center"><a href="#" class="posteItalianeElimina"><i class="icon-remove" style="color: red"></i></a></td></tr>
                {/foreach }
            </tbody>
        </table>
        Connetti il tuo account Poste Italiane oppure se non sei ancora cliente puoi richiedere l'apertura direttamente dal modulo
    </div>
</div>

<script>
    jQuery( document ).ready(function() {
        $(document).on("click", ".posteItalianeElimina", function() {
            var conf = confirm("Sei sicuro?");
            if (conf != true) return;

            var row = $(this).closest("tr");

            var carrierName = row.attr("carrier-name");
            var carrierId = row.attr("carrier-id");

            $.post( "{$deleteCarrierUrl|escape:'javascript':'utf-8'}", { "carrier_name" : carrierName, "carrier_id": carrierId })
            .done(function( data ) {
                $.growl.notice({
                    title: "",
                    size: "large",
                    message: "Eliminato!"
                });

                row.remove();
            });
        });
    });
</script>