<?php
/**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Poste Italiane
*  @copyright 2010-2020 Poste Italiane SPA
*  @license   LICENSE.txt
*/

set_time_limit(0);

include_once('../../config/config.inc.php');
include_once('../../init.php');
include_once('../../modules/posteitaliane/posteitaliane.php');

$posteItaliane = new PosteItaliane();

if ( !$posteItaliane->isAdmin() ) exit(200);

$idOrder = Tools::getValue("posteitaliane_ritiro_numero_ordine");
$carrierObj = $posteItaliane->GetCarrierById(Tools::getValue("posteitaliane_ritiro_servizio"));

if (!$carrierObj)
{
    $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Message" => "Connetti almeno un corriere dalla pagina configurazione del modulo prima di procedere al ritiro"));
}

$datetime = DateTime::createFromFormat('d/m/Y H:i', Tools::getValue("posteitaliane_ritiro_data"));
$pickupTime = $datetime->getTimestamp();

if ($pickupTime < strtotime("+30 minutes"))
{
    $posteItaliane->ThrowAPIResponse(array("Result" => "NOK", "Message" => "La data di ritiro deve essere almeno 30 minuti in avanti"));
}

$shippedOrders = $posteItaliane->getShippedOrders($idOrder);

$totalParcels = [];
$orderIds = [];

foreach ($shippedOrders as $shippedOrder)
{
    $totalParcels = array_merge($totalParcels, $shippedOrder->parcels);
    $orderIds[] = $shippedOrder->ordine_id;
}

$arr = array(
	"Method" => "BookPickup",
	"Params" => array(
		"from_address" => array(
			"name"    => Tools::getValue("posteitaliane_ritiro_ragionesociale"),
			"company" => Tools::getValue("posteitaliane_ritiro_ragionesociale"),
			"street1" => Tools::getValue("posteitaliane_ritiro_indirizzo"),
			"street2" => Tools::getValue("posteitaliane_ritiro_indirizzo2"),
			"city"    => Tools::getValue("posteitaliane_ritiro_citta"),
			"state"   => Tools::getValue("posteitaliane_ritiro_stato"),
			"zip"     => Tools::getValue("posteitaliane_ritiro_codicepostale"),
			"country" => Tools::getValue("posteitaliane_ritiro_nazione"),
			"phone"   => Tools::getValue("posteitaliane_ritiro_telefono"),
			"email"   => Tools::getValue("posteitaliane_ritiro_email"),
        ),
        "to_address" => array(
            "country" => "IT"
        ),
        "parcels"                => $totalParcels,
        "CarrierName"            => $carrierObj->CarrierName,
        "CarrierID"              => $carrierObj->CarrierID,
        "PickupTime"             => $pickupTime,
        "PickupMorningMintime"   => "09:00",
        "PickupMorningMaxtime"   => "12:00",
        "PickupAfternoonMintime" => "15:00",
        "PickupAfternoonMaxtime" => "18:00",
        "PickupNote"             => Tools::getValue("posteitaliane_ritiro_note"),
        "orderIds"               => implode(";", $orderIds)
	)
);

$resp = $posteItaliane->ApiRequest($arr);

$posteItaliane->ThrowAPIResponse($resp);

?>