{*
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*}
<script>
    function confirmDelete(idOrder){
        var result = confirm("{l s='Are you sure to delete this transaction?' mod='pospostepay'}");
        if (result === true){
            return true;
        } else {
            return false;
        }
    }

    function noContract(){
        var result = confirm("{l s='To use the payment platform it is necessary to sign a contract with PostePay. For a contact with one of our sales representatives, you can call the number: 800.00.88.11 (free toll-free number, from landlines and mobile phones, active from 8 to 20 from Monday to Saturday).' mod='pospostepay'}");
        if (result === true){
            return true;
        } else {
            return false;
        }
    }

    $(window).load(function() {
        if ($('#scroll').css('display') != 'none') {
            $("html, body").animate({ scrollTop: $(document).height() }, 1000);
        }
    });
</script>
<style>
    .linkbutton {
        text-decoration:none;
        height:51px;
    }

</style>
<ps-panel>
    <img width="150" alt="{l s='POS PostePay' mod='pospostepay'}" title="{l s='POS PostePay' mod='pospostepay'}" src="{$this_path_logo|escape:'htmlall':'UTF-8'}">
    <a style="color:#fff;background-color:#666;border-color:#666;text-align:center;line-height:38px;float:right;border-radius:7px;" href="{$this_path_manuale|escape:'htmlall':'UTF-8'}" target="_blank" class="btn btn-default linkbutton">{l s='Configuration manual' mod='pospostepay'}</a>
    <a style="color:#fff;background-color:#fff;border-color:#666;text-align:center;line-height:38px;float:right;width:10px;">&nbsp;</a>
    <a style="color:#fff;background-color:#666;border-color:#666;text-align:center;line-height:38px;float:right;border-radius:7px;" onclick="noContract()" target="_blank" class="btn btn-default linkbutton">{l s='Don\'t have a contract with PostePay yet?' mod='pospostepay'}</a>
    <a style="color:#fff;background-color:#fff;border-color:#666;text-align:center;line-height:38px;float:right;width:10px;">&nbsp;</a>
</ps-panel>
<form class="form-horizontal" method="post">
    <ps-panel header="{l s='General parameters' mod='pospostepay'}">
        <div class="form-wrapper">
            <div class="form-group">
                <ps-select name="POSPOSTEPAY_ACCOUNTINGMODE" label="{l s='Accounting' mod='pospostepay'}" active="{if $POSPOSTEPAY_ACCOUNTINGMODE=='switch'}true{else}false{/if}">
                  <option value="I" {if $POSPOSTEPAY_ACCOUNTINGMODE=='I'}selected{/if} label="{l s='Instant' mod='pospostepay'}">{l s='Instant' mod='pospostepay'}</option>
                  <option value="D" {if $POSPOSTEPAY_ACCOUNTINGMODE=='D'}selected{/if} label="{l s='Delayed' mod='pospostepay'}">{l s='Delayed' mod='pospostepay'}</option>
                </ps-select>
                <label class="control-label col-lg-3 ">
                </label>
                <label class="control-label col-lg-9 " style="text-align: left">
                    <p class="help-block">{l s='Select the type of accounting.' mod='pospostepay'}</p>
                    {l s='If you choose deferred accounting we remind you to turn on the booking confirmation function on your bank\'s portal.' mod='pospostepay'}
                </label>
            </div>

            <br>

            <div class="form-group">
                <label class="control-label col-lg-3 ">
                </label>
                <label class="control-label col-lg-9 " style="text-align: left">
                    <p class="help-block" style="font-weight: bold">{l s='ATTENTION! Enable the payment options below only if you have specifically requested them in the VPOS acquiring contract with Postepay.' mod='pospostepay'}</p>
                </label>
            </div>
            <div class="form-group">
                <ps-switch name="POSPOSTEPAY_CARD_ENABLED" label="{l s='Enable button \"Pay with other payment cards\"' mod='pospostepay'}" yes="{l s='Yes' mod='pospostepay'}" no="{l s='No' mod='pospostepay'}"  active="{if $POSPOSTEPAY_CARD_ENABLED==1}true{else}false{/if}"></ps-switch>
                <label class="control-label col-lg-3 ">
                </label>
                <label class="control-label col-lg-9 " style="text-align: left">
                    <p class="help-block">{l s='Only if you have requested it through a contract with PostePay SpA.' mod='pospostepay'}</p>
                    <p class="help-block">{l s='By selecting this flag, you enable the payment button \"Pay with other payment cards\" and display the VISA and Mastercard logos on the payment page of your web/App. If you have not requested in your contract with Postepay also the enabling of the acceptance of VISA and Mastercard cards issued by other banking institutions, payments with these cards will not be successful.' mod='pospostepay'}</p>
                </label>
            </div>

            <br>
        
            <div class="form-group">
                <ps-switch name="POSPOSTEPAY_AMEX_ENABLED" label="{l s='Add American Express logo for the \"Pay with other payment cards\" button' mod='pospostepay'}" yes="{l s='Yes' mod='pospostepay'}" no="{l s='No' mod='pospostepay'}"  active="{if $POSPOSTEPAY_AMEX_ENABLED==1}true{else}false{/if}"></ps-switch>
                <label class="control-label col-lg-3 ">
                </label>
                <label class="control-label col-lg-9 " style="text-align: left">
                    <p class="help-block">{l s='By selecting this flag, you also display the American Express logo, as well as VISA and Mastercard, in correspondence with the payment button \"Pay with other payment cards\". If you have not requested the acceptance of Amex cards in your contract with Postepay and American Express, payments with these cards will not be successful.' mod='pospostepay'}</p>
                </label>
            </div>
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit name="btnSubmit" icon="process-icon-save" title="{l s='Save' mod='pospostepay'}" direction="right"></<ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    <ps-panel header="{l s='Settings test server' mod='pospostepay'}">
        <div class="form-wrapper">
            <ps-switch name="POSPOSTEPAY_TEST_ENABLED" label="{l s='Enable TEST server' mod='pospostepay'}" yes="{l s='Yes' mod='pospostepay'}" no="{l s='No' mod='pospostepay'}"  active="{if $POSPOSTEPAY_TEST_ENABLED==1}true{else}false{/if}"></ps-switch>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Gateway URL TEST server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_TEST_URL_PAYMENT|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_TEST_URL_PAYMENT" class="input" disabled>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Shop code TEST server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_TEST_SHOPID|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_TEST_SHOPID" class="input" disabled>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Start key TEST server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_TEST_MAC_KEY|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_TEST_MAC_KEY" class="input" disabled>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='API-Result key TEST server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_TEST_MAC_KEY_RESPONSE|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_TEST_MAC_KEY_RESPONSE" class="input" disabled>
                    </div>
                </div>
            </div>
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit name="btnSubmit" icon="process-icon-save" title="{l s='Save' mod='pospostepay'}" direction="right"></<ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    <ps-panel header="{l s='Settings production server' mod='pospostepay'}">
        <div class="form-wrapper">
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Gateway URL PRODUCTION server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_URL_PAYMENT|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_URL_PAYMENT" class="input" disabled>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Shop code PRODUCTION server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_SHOPID|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_SHOPID" class="input">
                        <p class="help-block">{l s='Insert the shop code provided by Poste Italiane.' mod='pospostepay'}</p>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='Start key PRODUCTION server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_MAC_KEY|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_MAC_KEY" class="input">
                        <p class="help-block">{l s='Insert the start key provided by Poste Italiane.' mod='pospostepay'}</p>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3 ">
                    <span>{l s='API-Result key PRODUCTION server' mod='pospostepay'}</span>
                </label>
                <div class="col-lg-9">
                    <div>
                        <input type="text" value="{$POSPOSTEPAY_MAC_KEY_RESPONSE|escape:'htmlall':'UTF-8'}" size="100" name="POSPOSTEPAY_MAC_KEY_RESPONSE" class="input">
                        <p class="help-block">{l s='Insert the API-Result key provided by Poste Italiane.' mod='pospostepay'}</p>
                    </div>
                </div>
            </div>
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit name="btnSubmit" icon="process-icon-save" title="{l s='Save' mod='pospostepay'}" direction="right"></<ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
</form>
<ps-panel header="{l s='Transactions list' mod='pospostepay'}">
    <form id="filtertransactionForm" method="post" class="form-horizontal">
        <div class="input-group">
            <span class="input-group-addon">
                <i class="icon-search"></i>
            </span>
            <input name="SEARCH"class="form-control" placeholder="{l s='Search' mod='pospostepay'}" type="text" value="{$Search|escape:'htmlall':'UTF-8'}" style="width:10%">
            <input name="type" type="hidden" value="1">
            <button type="submit" name="search" class="btn  btn-default">{l s='Search' mod='pospostepay'}</button>&emsp;
            <button type="submit" name="exportTrans" class="btn  btn-default">{l s='Export as CSV' mod='pospostepay'}</button>
        </div>
    </form>
        
    <style>

    @media (max-width: 992px) {
                    .table-responsive-row td:nth-of-type(1):before {
                content: "ID ord.";
            }
                    .table-responsive-row td:nth-of-type(2):before {
                content: "Currency";
            }
                    .table-responsive-row td:nth-of-type(3):before {
                content: "Amount";
            }
                    .table-responsive-row td:nth-of-type(4):before {
                content: "User";
            }
                    .table-responsive-row td:nth-of-type(5):before {
                content: "Email";
            }
                    .table-responsive-row td:nth-of-type(6):before {
                content: "Test";
            }
                    .table-responsive-row td:nth-of-type(7):before {
                content: "ID trans.";
            }
                    .table-responsive-row td:nth-of-type(8):before {
                content: "Response";
            }
                    .table-responsive-row td:nth-of-type(9):before {
                content: "Date";
            }
                    .table-responsive-row td:nth-of-type(9):before {
                        content: "Status";
            }
            .table-responsive-row td:nth-of-type(9):before {
                        content: "Authorization number";
            }
            }


    
    </style>
    <div class="table-responsive-row clearfix">
        <table class="table">
            <thead>
                <tr class="nodrag nodrop">
                    <th class="center">
                        <span class="title_box">
                            {l s='ID ord.' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Currency' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Amount' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='User' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Email' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Test' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Authorization number' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='ID Trans.' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Response' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Date' mod='pospostepay'}
                        </span>
                    </th>
                    <th class="center">
                        <span class="title_box">
                            {l s='Status' mod='pospostepay'}
                        </span>
                    </th>
                </tr>
            </thead>
            {foreach $transactions as $trans}
                <tr>
                    <td class="center">
                        {if $trans.id_order != 0}
                            <a href="{$linkOrder|escape:'htmlall':'UTF-8'}{$trans.id_order|escape:'htmlall':'UTF-8'}&vieworder&token={$token|escape:'htmlall':'UTF-8'}" style="color:#666;text-decoration: underline;">{$trans.id_order|escape:'htmlall':'UTF-8'}</a>
                        {/if}
                        {if $trans.id_order == 0}
                            {$trans.id_order|escape:'htmlall':'UTF-8'}
                        {/if}
                    </td>
                    <td class="center">{$trans.currency|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.total|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.user|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.email|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.test|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.auth_number|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">
                        {if $trans.id_order != 0}
                            <a href="{$linkOrderStatus|escape:'htmlall':'UTF-8'}{$tokenOrderStatus|escape:'htmlall':'UTF-8'}&orderId={$trans.order_id|escape:'htmlall':'UTF-8'}" title="{l s='Order status' mod='pospostepay'}" style="color:#666;text-decoration: underline;">{$trans.order_id|escape:'htmlall':'UTF-8'}</a>
                        {/if}
                        {if $trans.id_order == 0}
                            {$trans.order_id|escape:'htmlall':'UTF-8'}
                        {/if}
                    </td>
                    <td class="center">{$trans.result|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">{$trans.date_trans|escape:'htmlall':'UTF-8'}</td>
                    <td class="center">
                        {if $trans.state == "PAYMENT ACCEPTED"}
                            {l s='PAYMENT ACCEPTED' mod='pospostepay'}
                        {/if}
                        {if $trans.state == "CANCELED"}
                            {l s='CANCELED' mod='pospostepay'}
                        {/if}
                    </td>
                </tr>
            {/foreach}
        </table>
    </div>
</ps-panel>
<ps-panel header="{l s='Order status' mod='pospostepay'} - {$order_id_trans|escape:'htmlall':'UTF-8'}" id="scroll" style="display:{$displayOrder|escape:'htmlall':'UTF-8'};">
    {l s='Timestamp' mod='pospostepay'}: {$orderStatusTimeStamp|escape:'htmlall':'UTF-8'}<br>

    {l s='Payment type' mod='pospostepay'}: 
    {if $orderStatusPaymentType == "04"}
        {l s='VBV: merchant and consumer adhering to VBV' mod='pospostepay'}
    {/if}
    {if $orderStatusPaymentType == "03"}
        {l s='SSL' mod='pospostepay'}
    {/if}
    {if $orderStatusPaymentType == "05"}
        {l s='SecureCode: merchant and consumer adhering to SecureCode' mod='pospostepay'}
    {/if}
    {if $orderStatusPaymentType == "07"}
        {l s='Merchant SecureCode: merchant adhering to SecureCode and consumer not adhering' mod='pospostepay'}
    {/if}<br>

    {l s='Authorization type' mod='pospostepay'}: 
    {if $orderStatusAuthorizationType == "I"}
        {l s='Instant' mod='pospostepay'}
    {/if}
    {if $orderStatusAuthorizationType == "D"}
        {l s='Delayed' mod='pospostepay'}
    {/if}<br>
 
    {l s='Network' mod='pospostepay'}: 
    {if $orderStatusNetwork == "01"}
        {l s='Visa' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "06"}
        {l s='Amex' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "07"}
        {l s='Diners' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "08"}
        {l s='JCB' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "10"}
        {l s='Carta Aura' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "80"}
        {l s='IBAN' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "90"}
        {l s='PostePay Button' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "91"}
        {l s='Jiffy' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "96"}
        {l s='MyBank' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "97"}
        {l s='Paypal' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "94"}
        {l s='PostePay' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "02"}
        {l s='Mastercard' mod='pospostepay'}
    {/if}
    {if $orderStatusNetwork == "04"}
        {l s='Maestro' mod='pospostepay'}
    {/if}<br>

    {l s='Transaction ID' mod='pospostepay'}: {$orderStatusTransactionId|escape:'htmlall':'UTF-8'}<br>

    {l s='Order ID' mod='pospostepay'}: {$orderStatusOrderId|escape:'htmlall':'UTF-8'}<br>

    {l s='Transaction amount' mod='pospostepay'}: {$orderStatusTransactionAmount|escape:'htmlall':'UTF-8'}<br>
    {l s='Authorized amount' mod='pospostepay'}: {$orderStatusAuthorizedAmount|escape:'htmlall':'UTF-8'}<br>
    {l s='Accounted amount' mod='pospostepay'}: {$orderStatusAccountedAmount|escape:'htmlall':'UTF-8'}<br>
    {l s='Refunded amount' mod='pospostepay'}: {$orderStatusRefundedAmount|escape:'htmlall':'UTF-8'}<br>

    {l s='Currency' mod='pospostepay'}: {$orderStatusCurrency|escape:'htmlall':'UTF-8'}<br>

    {l s='Transaction status' mod='pospostepay'}: 
    {if $orderStatusTransactionStatus == "00"}
        {l s='Authorization granted, bookable' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "01"}
        {l s='Authorization denied' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "02"}
        {l s='Booked authorization to be processed' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "03"}
        {l s='Booked authorization processed by clearing' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "04"}
        {l s='Reversed authorization' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "21"}
        {l s='Authorization to be reversed due to transaction error' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "99"}
        {l s='Authorization underway with MyBank' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "10"}
        {l s='Deferred authorization open' mod='pospostepay'}
    {/if}
    {if $orderStatusTransactionStatus == "11"}
        {l s='Deferred authorization closed' mod='pospostepay'}
    {/if}<br>

    {l s='Authorization number' mod='pospostepay'}: {$orderStatusAuthorizationNumber|escape:'htmlall':'UTF-8'}
</ps-panel>
