<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class PosPostePayResponseFrontOffice
{
    private $transactionId;
    private $shopId;
    private $result;

    private $amount;
    private $currency;
    private $exponent;

    private $orderId;

    private $authNumber;

    private $mac;
    private $macKey;

    private $macCalculated;

    private $accountingMode;
    private $authorMode;

    private $transactionType;
    private $issuerCountry;

    private $network;



    /**
     * @return $this->the shopId
     */
    public function getShopId()
    {
        return $this->shopId;
    }

    /**
     * @param shopId
     *            the shopId to set
     */
    public function setShopId($shopId)
    {
        $this->shopId = $shopId;
    }

    /**
     * @return $this->the amount
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param amount
     *            the amount to set
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    /**
     * @return $this->the currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param currency
     *            the currency to set
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    /**
     * @return $this->the transactionId
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }

    /**
     * @param transactionId
     *            the transactionId to set
     */
    public function setTransactionId($transactionId)
    {
        $this->transactionId = $transactionId;
    }

    /**
     * @return $this->the orderId
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param orderId
     *            the orderId to set
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
    }

    /**
     * @return $this->the accountingMode
     */
    public function getAccountingMode()
    {
        return $this->accountingMode;
    }

    /**
     * @param accountingMode
     *            the accountingMode to set
     */
    public function setAccountingMode($accountingMode)
    {
        $this->accountingMode = $accountingMode;
    }

    /**
     * @return $this->the authorMode
     */
    public function getAuthorMode()
    {
        return $this->authorMode;
    }

    /**
     * @param authorMode
     *            the authorMode to set
     */
    public function setAuthorMode($authorMode)
    {
        $this->authorMode = $authorMode;
    }

    /**
     * @return $this->the exponent
     */
    public function getExponent()
    {
        return $this->exponent;
    }

    /**
     * @param exponent
     *            the exponent to set
     */
    public function setExponent($exponent)
    {
        $this->exponent = $exponent;
    }

    /**
     * @return $this->the macKey
     */
    public function getMacKey()
    {
        return $this->macKey;
    }

    /**
     * @param macKey
     *            the macKey to set
     */
    public function setMacKey($macKey)
    {
        $this->macKey = $macKey;
    }

    /**
     * @return $this->the mac
     */
    public function getMac()
    {
        return $this->mac;
    }

    /**
     * @param mac
     *            the mac to set
     */
    public function setMac($mac)
    {
        $this->mac = $mac;
    }

    /**
     * @return $this->the result
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @param result
     *            the result to set
     */
    public function setResult($result)
    {
        $this->result = $result;
    }

    /**
     * @return $this->the authNumber
     */
    public function getAuthNumber()
    {
        return $this->authNumber;
    }

    /**
     * @param authNumber
     *            the authNumber to set
     */
    public function setAuthNumber($authNumber)
    {
        $this->authNumber = $authNumber;
    }

    /**
     * @return $this->the issuerCountry
     */
    public function getIssuerCountry()
    {
        return $this->issuerCountry;
    }

    /**
     * @param issuerCountry
     *            the issuerCountry to set
     */
    public function setIssuerCountry($issuerCountry)
    {
        $this->issuerCountry = $issuerCountry;
    }


    /**
     * @return $this->the transactionType
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }

    /**
     * @param transactionType
     *            the transactionType to set
     */
    public function setTransactionType($transactionType)
    {
        $this->transactionType = $transactionType;
    }


    /**
     * @return $this->the network
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * @param network
     *            the network to set
     */
    public function setNetwork($network)
    {
        $this->network = $network;
    }


    /**
     * @return $this->the macCalculated
     */
    public function getMacCalculated()
    {
        return $this->macCalculated;
    }

    /**
     * @param macCalculated
     *            the macCalculated to set
     */
    public function setMacCalculated($macCalculated)
    {
        $this->macCalculated = $macCalculated;
    }

    public function calculateMac()
    {
        $toHash = 'ORDERID=';
        $toHash .= $this->orderId;
        $toHash .= '&SHOPID=';
        $toHash .= $this->shopId;
        $toHash .= '&AUTHNUMBER=';
        $toHash .= $this->authNumber=="NULL"?"NULL":$this->authNumber;

        $toHash .= '&AMOUNT=';
        $toHash .= $this->amount;

        $toHash .= '&CURRENCY=';
        $toHash .= $this->currency;

        $toHash .= '&TRANSACTIONID=';
        $toHash .= $this->transactionId;

        $toHash .= '&ACCOUNTINGMODE=';
        $toHash .= $this->accountingMode;

        $toHash .= '&AUTHORMODE=';
        $toHash .= $this->authorMode;
        $toHash .= '&RESULT=';
        $toHash .= $this->result;
        $toHash .= '&TRANSACTIONTYPE=';
        $toHash .= $this->transactionType;
        if ($this->issuerCountry!='') {
            $toHash .= '&ISSUER_COUNTRY=';
            $toHash .= $this->issuerCountry;
        }

        $toHash .= "&".$this->macKey;
        $this->macCalculated = sha1($toHash);
    }

    public function responseVerified()
    {
        return Tools::strtolower($this->mac) == Tools::strtolower($this->macCalculated);
    }
}
