<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class PosPostePayPaymentinitModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $this->setTemplate('module:pospostepay/views/templates/front/wait.tpl');
        $cart = $this->context->cart;
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 ||
            $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'pospostepay') {
                $authorized = true;
                break;
            }
        }
        if (!$authorized) {
            die($this->module->l('This payment method is not available.', 'validation'));
        }

        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $paymentGateway = $this->module->getConfiguration();

        $rfo = new PosPostePayRequestFrontOffice($paymentGateway->urlPayment);

        $rfo->setShopId($paymentGateway->shopId);
        $rfo->setMacKey($paymentGateway->macKey);

        $name = str_replace("www.", "", Configuration::get('PS_SHOP_NAME'));

        preg_replace('/[^A-Za-z0-9 ]/', '', $name);
        str_replace(" ", "_", $name);
        $name = Tools::substr(Tools::strtolower($name), 0, 4);

        $rfo->setOrderId($name.rand(10000000, 99999999).'_'.$cart->id);
        $lang = "ITA";
        switch (Tools::strtolower($this->context->language->iso_code)) {
            case 'it':
                $lang = "ITA";
                break;
            case 'en':
                $lang = "EN";
                break;
            default:
                $lang = "EN";
                break;
        }
        $rfo->setLanguageId($lang);

        $rfo->setUrl($paymentGateway->resultURL);

        $rfo->setUrlBack($paymentGateway->errorURL);
        $rfo->setUrlpost($paymentGateway->resultURLPost);

        $rfo->setAuthorMode($paymentGateway->authorMode);
        $rfo->setAccountingMode($paymentGateway->accountingMode);

        $total = (float) $cart->getOrderTotal(true, Cart::BOTH);
        $currency = new Currency($cart->id_currency);
        $rfo->setCurrency('978');
        if ($currency->iso_code != "EUR") {
            $id_cur_to = (int)Currency::getIdByIsoCode('EUR');
            $currency_to = new Currency($id_cur_to);
            $id_cur_prev = (int)Currency::getIdByIsoCode($currency->iso_code);
            $currency_prev = new Currency((int)$id_cur_prev);

            $total = Tools::convertPrice($total, $currency_prev, false);
            $total = Tools::ps_round(Tools::convertPrice($total, $currency_to, true), 2);
        }
        $totalTemp = ($total * 100);
        if (stripos($totalTemp, ".") !== false) {
            $res = Tools::substr($totalTemp, 0, stripos($totalTemp, "."));
        } else {
            $res = $totalTemp;
        }
        $rfo->setAmount($res);

        $rfo->setOptions("G");

        $rfo->setPlugin("PrestaShop-POSTE");
        $rfo->setPluginVersion($this->module->version);

        $paymentTpe = Tools::getValue('payment');
        if ($paymentTpe == "creditcard") {
            $rfo->setLockCard("CC");
        } else if ($paymentTpe == "postepay") {
            $rfo->setLockCard("92");
        }

        $test = 0;
        if (Configuration::get('POSPOSTEPAY_TEST_ENABLED')) {
            $test = 1;
        }
        Db::getInstance()->insert('pospostepay_payment_verification', array(
            'cart_id' => (int) $cart->id,
            'order_id' => pSQL($rfo->getOrderId()),
            'total' => (float) $total,
            'user' => (string) pSQL($customer->firstname." ".$customer->lastname),
            'email' => (string) pSQL($customer->email),
            'test' => (int) $test,
            'currency' => (string) $currency->name
        ));
        $rfo->setMacKey($paymentGateway->macKey);
        $addr1 = new Address($cart->id_address_invoice);
        $ds = new \stdClass();
        if ($cart->id_address_delivery == $cart->id_address_invoice) {
            $ds->addrMatch = "Y";
        } else {
            $ds->addrMatch = "N";
        }
        $ds->acctID = $cart->id_customer;
        $ds->billAddrCity = $addr1->city;
        $country1 = new Country($addr1->id_country);
        $ds->billAddrCountry = $this->getIsoCodeCountry($country1->iso_code);
        $ds->billAddrLine1 = $addr1->address1;
        $ds->billAddrPostCode = $addr1->postcode;
        $state1 = new State($addr1->id_state);
        $ds->billAddrState = $state1->iso_code;
        if ($ds->addrMatch == "N") {
            $addr2 = new Address($cart->id_customer);
            $ds->shipAddrCity = $addr2->city;
            $country2 = new Country($addr2->id_country);
            $ds->shipAddrCountry = $this->getIsoCodeCountry($country2->iso_code);
            $ds->shipAddrLine1 = $addr2->address1;
            $ds->shipAddrPostCode = $addr2->postcode;
            $state2 = new State($addr2->id_state);
            $ds->shipAddrState = $state2->iso_code;
        }
        $JSON = json_encode($ds);

        $encrypted = $this->encrypt($JSON, $paymentGateway->macKeyResponse);
            
        $rfo->setDSData($encrypted);
        
        $rfo->calculateMacDsData();

        $campi = array(
            'PAGE' => 'LAND',
            'AMOUNT' => $rfo->getAmount(),
            'CURRENCY' => $rfo->getCurrency(),
            'SHOPID' => $rfo->getShopId(),
            'ORDERID' => $rfo->getOrderId(),
            'URLDONE' => $rfo->getUrl(),
            'URLBACK' => $rfo->getUrlBack(),
            'URLMS' => $rfo->getUrlpost(),
            'ACCOUNTINGMODE' => $rfo->getAccountingMode(),
            'AUTHORMODE' => $rfo->getAuthorMode(),
            'LANG' => $rfo->getLanguageId(),
            'OPTIONS' => $rfo->getOptions(),
            'PLUGIN' => $rfo->getPlugin(),
            'PLUGINVERSION' => $rfo->getPluginVersion(),
            'LOCKCARD' => $rfo->getLockCard(),
            'SHOPEMAIL' => Configuration::get('PS_SHOP_EMAIL'),
            '3DSDATA' => $rfo->getDSData(),
            'MAC' => $rfo->getMac()
        );
            //}

        $dati = '';
        foreach ($campi as $k => $v) {
            $dati .= $k . '=' . urlencode($v) . '&';
        }
        rtrim($dati, '&');
            
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $rfo->getUrlRequest());
          
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dati);
           
        curl_exec($ch);
        curl_close($ch);
    }

    public function encrypt($json, $password)
    {
        $method = "AES-128-CBC";
        $key = Tools::substr($password, 0, 16);
        
        $iv = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

        $ciphertext = openssl_encrypt($json, $method, $key, OPENSSL_RAW_DATA, $iv);
        
        $result = base64_encode($ciphertext);
        
        return $result;
    }

    public function getIsoCodeCountry($isoCodeAlfa)
    {
        $isoCode="";
        
        switch ($isoCodeAlfa) {
            case "AD":
                $isoCode="020";
                break;
            case "AE":
                $isoCode="784";
                break;
            case "AF":
                $isoCode="004";
                break;
            case "AG":
                $isoCode="028";
                break;
            case "AI":
                $isoCode="660";
                break;
            case "AL":
                $isoCode="008";
                break;
            case "AM":
                $isoCode="051";
                break;
            case "AO":
                $isoCode="024";
                break;
            case "AQ":
                $isoCode="010";
                break;
            case "AR":
                $isoCode="032";
                break;
            case "AS":
                $isoCode="016";
                break;
            case "AT":
                $isoCode="040";
                break;
            case "AU":
                $isoCode="036";
                break;
            case "AW":
                $isoCode="533";
                break;
            case "AX":
                $isoCode="248";
                break;
            case "AZ":
                $isoCode="031";
                break;
            case "BA":
                $isoCode="070";
                break;
            case "BB":
                $isoCode="052";
                break;
            case "BD":
                $isoCode="050";
                break;
            case "BE":
                $isoCode="056";
                break;
            case "BF":
                $isoCode="854";
                break;
            case "BG":
                $isoCode="100";
                break;
            case "BH":
                $isoCode="048";
                break;
            case "BI":
                $isoCode="108";
                break;
            case "BJ":
                $isoCode="204";
                break;
            case "BL":
                $isoCode="652";
                break;
            case "BM":
                $isoCode="060";
                break;
            case "BN":
                $isoCode="096";
                break;
            case "BO":
                $isoCode="068";
                break;
            case "BQ":
                $isoCode="535";
                break;
            case "BR":
                $isoCode="076";
                break;
            case "BS":
                $isoCode="044";
                break;
            case "BT":
                $isoCode="064";
                break;
            case "BV":
                $isoCode="074";
                break;
            case "BW":
                $isoCode="072";
                break;
            case "BY":
                $isoCode="112";
                break;
            case "BZ":
                $isoCode="084";
                break;
            case "CA":
                $isoCode="124";
                break;
            case "CC":
                $isoCode="166";
                break;
            case "CD":
                $isoCode="180";
                break;
            case "CF":
                $isoCode="140";
                break;
            case "CG":
                $isoCode="178";
                break;
            case "CH":
                $isoCode="756";
                break;
            case "CI":
                $isoCode="384";
                break;
            case "CK":
                $isoCode="184";
                break;
            case "CL":
                $isoCode="152";
                break;
            case "CM":
                $isoCode="120";
                break;
            case "CN":
                $isoCode="156";
                break;
            case "CO":
                $isoCode="170";
                break;
            case "CR":
                $isoCode="188";
                break;
            case "CU":
                $isoCode="192";
                break;
            case "CV":
                $isoCode="132";
                break;
            case "CW":
                $isoCode="531";
                break;
            case "CX":
                $isoCode="162";
                break;
            case "CY":
                $isoCode="196";
                break;
            case "CZ":
                $isoCode="203";
                break;
            case "DE":
                $isoCode="276";
                break;
            case "DJ":
                $isoCode="262";
                break;
            case "DK":
                $isoCode="208";
                break;
            case "DM":
                $isoCode="212";
                break;
            case "DO":
                $isoCode="214";
                break;
            case "DZ":
                $isoCode="012";
                break;
            case "EC":
                $isoCode="218";
                break;
            case "EE":
                $isoCode="233";
                break;
            case "EG":
                $isoCode="818";
                break;
            case "EH":
                $isoCode="732";
                break;
            case "ER":
                $isoCode="232";
                break;
            case "ES":
                $isoCode="724";
                break;
            case "ET":
                $isoCode="231";
                break;
            case "FI":
                $isoCode="246";
                break;
            case "FJ":
                $isoCode="242";
                break;
            case "FK":
                $isoCode="238";
                break;
            case "FM":
                $isoCode="583";
                break;
            case "FO":
                $isoCode="234";
                break;
            case "FR":
                $isoCode="250";
                break;
            case "GA":
                $isoCode="266";
                break;
            case "GB":
                $isoCode="826";
                break;
            case "GD":
                $isoCode="308";
                break;
            case "GE":
                $isoCode="268";
                break;
            case "GF":
                $isoCode="254";
                break;
            case "GG":
                $isoCode="831";
                break;
            case "GH":
                $isoCode="288";
                break;
            case "GI":
                $isoCode="292";
                break;
            case "GL":
                $isoCode="304";
                break;
            case "GM":
                $isoCode="270";
                break;
            case "GN":
                $isoCode="324";
                break;
            case "GP":
                $isoCode="312";
                break;
            case "GQ":
                $isoCode="226";
                break;
            case "GR":
                $isoCode="300";
                break;
            case "GS":
                $isoCode="239";
                break;
            case "GT":
                $isoCode="320";
                break;
            case "GU":
                $isoCode="316";
                break;
            case "GW":
                $isoCode="624";
                break;
            case "GY":
                $isoCode="328";
                break;
            case "HK":
                $isoCode="344";
                break;
            case "HM":
                $isoCode="334";
                break;
            case "HN":
                $isoCode="340";
                break;
            case "HR":
                $isoCode="191";
                break;
            case "HT":
                $isoCode="332";
                break;
            case "HU":
                $isoCode="348";
                break;
            case "ID":
                $isoCode="360";
                break;
            case "IE":
                $isoCode="372";
                break;
            case "IL":
                $isoCode="376";
                break;
            case "IM":
                $isoCode="833";
                break;
            case "IN":
                $isoCode="356";
                break;
            case "IO":
                $isoCode="086";
                break;
            case "IQ":
                $isoCode="368";
                break;
            case "IR":
                $isoCode="364";
                break;
            case "IS":
                $isoCode="352";
                break;
            case "IT":
                $isoCode="380";
                break;
            case "JE":
                $isoCode="832";
                break;
            case "JM":
                $isoCode="388";
                break;
            case "JO":
                $isoCode="400";
                break;
            case "JP":
                $isoCode="392";
                break;
            case "KE":
                $isoCode="404";
                break;
            case "KG":
                $isoCode="417";
                break;
            case "KH":
                $isoCode="116";
                break;
            case "KI":
                $isoCode="296";
                break;
            case "KM":
                $isoCode="174";
                break;
            case "KN":
                $isoCode="659";
                break;
            case "KP":
                $isoCode="408";
                break;
            case "KR":
                $isoCode="410";
                break;
            case "KW":
                $isoCode="414";
                break;
            case "KY":
                $isoCode="136";
                break;
            case "KZ":
                $isoCode="398";
                break;
            case "LA":
                $isoCode="418";
                break;
            case "LB":
                $isoCode="422";
                break;
            case "LC":
                $isoCode="662";
                break;
            case "LI":
                $isoCode="438";
                break;
            case "LK":
                $isoCode="144";
                break;
            case "LR":
                $isoCode="430";
                break;
            case "LS":
                $isoCode="426";
                break;
            case "LT":
                $isoCode="440";
                break;
            case "LU":
                $isoCode="442";
                break;
            case "LV":
                $isoCode="428";
                break;
            case "LY":
                $isoCode="434";
                break;
            case "MA":
                $isoCode="504";
                break;
            case "MC":
                $isoCode="492";
                break;
            case "MD":
                $isoCode="498";
                break;
            case "ME":
                $isoCode="499";
                break;
            case "MF":
                $isoCode="663";
                break;
            case "MG":
                $isoCode="450";
                break;
            case "MH":
                $isoCode="584";
                break;
            case "MK":
                $isoCode="807";
                break;
            case "ML":
                $isoCode="466";
                break;
            case "MM":
                $isoCode="104";
                break;
            case "MN":
                $isoCode="496";
                break;
            case "MO":
                $isoCode="446";
                break;
            case "MP":
                $isoCode="580";
                break;
            case "MQ":
                $isoCode="474";
                break;
            case "MR":
                $isoCode="478";
                break;
            case "MS":
                $isoCode="500";
                break;
            case "MT":
                $isoCode="470";
                break;
            case "MU":
                $isoCode="480";
                break;
            case "MV":
                $isoCode="462";
                break;
            case "MW":
                $isoCode="454";
                break;
            case "MX":
                $isoCode="484";
                break;
            case "MY":
                $isoCode="458";
                break;
            case "MZ":
                $isoCode="508";
                break;
            case "NA":
                $isoCode="516";
                break;
            case "NC":
                $isoCode="540";
                break;
            case "NE":
                $isoCode="562";
                break;
            case "NF":
                $isoCode="574";
                break;
            case "NG":
                $isoCode="566";
                break;
            case "NI":
                $isoCode="558";
                break;
            case "NL":
                $isoCode="528";
                break;
            case "NO":
                $isoCode="578";
                break;
            case "NP":
                $isoCode="524";
                break;
            case "NR":
                $isoCode="520";
                break;
            case "NU":
                $isoCode="570";
                break;
            case "NZ":
                $isoCode="554";
                break;
            case "OM":
                $isoCode="512";
                break;
            case "PA":
                $isoCode="591";
                break;
            case "PE":
                $isoCode="604";
                break;
            case "PF":
                $isoCode="258";
                break;
            case "PG":
                $isoCode="598";
                break;
            case "PH":
                $isoCode="608";
                break;
            case "PK":
                $isoCode="586";
                break;
            case "PL":
                $isoCode="616";
                break;
            case "PM":
                $isoCode="666";
                break;
            case "PN":
                $isoCode="612";
                break;
            case "PR":
                $isoCode="630";
                break;
            case "PS":
                $isoCode="275";
                break;
            case "PT":
                $isoCode="620";
                break;
            case "PW":
                $isoCode="585";
                break;
            case "PY":
                $isoCode="600";
                break;
            case "QA":
                $isoCode="634";
                break;
            case "RE":
                $isoCode="638";
                break;
            case "RO":
                $isoCode="642";
                break;
            case "RS":
                $isoCode="688";
                break;
            case "RU":
                $isoCode="643";
                break;
            case "RW":
                $isoCode="646";
                break;
            case "SA":
                $isoCode="682";
                break;
            case "SB":
                $isoCode="090";
                break;
            case "SC":
                $isoCode="690";
                break;
            case "SD":
                $isoCode="729";
                break;
            case "SE":
                $isoCode="752";
                break;
            case "SG":
                $isoCode="702";
                break;
            case "SH":
                $isoCode="654";
                break;
            case "SI":
                $isoCode="705";
                break;
            case "SJ":
                $isoCode="744";
                break;
            case "SK":
                $isoCode="703";
                break;
            case "SL":
                $isoCode="694";
                break;
            case "SM":
                $isoCode="674";
                break;
            case "SN":
                $isoCode="686";
                break;
            case "SO":
                $isoCode="706";
                break;
            case "SR":
                $isoCode="740";
                break;
            case "SS":
                $isoCode="728";
                break;
            case "ST":
                $isoCode="678";
                break;
            case "SV":
                $isoCode="222";
                break;
            case "SX":
                $isoCode="534";
                break;
            case "SY":
                $isoCode="760";
                break;
            case "SZ":
                $isoCode="748";
                break;
            case "TC":
                $isoCode="796";
                break;
            case "TD":
                $isoCode="148";
                break;
            case "TF":
                $isoCode="260";
                break;
            case "TG":
                $isoCode="768";
                break;
            case "TH":
                $isoCode="764";
                break;
            case "TJ":
                $isoCode="762";
                break;
            case "TK":
                $isoCode="772";
                break;
            case "TL":
                $isoCode="626";
                break;
            case "TM":
                $isoCode="795";
                break;
            case "TN":
                $isoCode="788";
                break;
            case "TO":
                $isoCode="776";
                break;
            case "TR":
                $isoCode="792";
                break;
            case "TT":
                $isoCode="780";
                break;
            case "TV":
                $isoCode="798";
                break;
            case "TW":
                $isoCode="158";
                break;
            case "TZ":
                $isoCode="834";
                break;
            case "UA":
                $isoCode="804";
                break;
            case "UG":
                $isoCode="800";
                break;
            case "UM":
                $isoCode="581";
                break;
            case "US":
                $isoCode="840";
                break;
            case "UY":
                $isoCode="858";
                break;
            case "UZ":
                $isoCode="860";
                break;
            case "VA":
                $isoCode="336";
                break;
            case "VC":
                $isoCode="670";
                break;
            case "VE":
                $isoCode="862";
                break;
            case "VG":
                $isoCode="092";
                break;
            case "VI":
                $isoCode="850";
                break;
            case "VN":
                $isoCode="704";
                break;
            case "VU":
                $isoCode="548";
                break;
            case "WF":
                $isoCode="876";
                break;
            case "WS":
                $isoCode="882";
                break;
            case "YE":
                $isoCode="887";
                break;
            case "YT":
                $isoCode="175";
                break;
            case "ZA":
                $isoCode="710";
                break;
            case "ZM":
                $isoCode="894";
                break;
            case "ZW":
                $isoCode="716";
                break;
            default:
                $isoCode="380";
                break;
        }

        return $isoCode;
    }
}
