<?php
/**
* 2007-2020.
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you are unable to obtain it through the world-wide-web, please
* send an email to PostePay SpA so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize this module for your special
* needs please send an email to PostePay SpA for more information.
*
*  @author    PostePay SpA
*  @copyright 2007-2021
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class PosPostePayKoModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->display_column_left = false;
        parent::initContent();

        $paymentGateway = $this->module->getConfiguration();

        $rfo = new PosPostePayResponseFrontOffice();

        $rfo->setMacKey($paymentGateway->macKeyResponse);

        $rfo->setAmount(Tools::getValue('AMOUNT'));
        $rfo->setCurrency(Tools::getValue('CURRENCY'));
        $rfo->setOrderId(Tools::getValue('ORDERID'));

        $rfo->setResult(Tools::getValue('RESULT'));
        
        $error = '';

        switch ($rfo->getResult()) {
            case '01':
            $error = $this->module->l('Duplicate order');
            break;
            case '02':
            $error = $this->module->l('Problems with the store registry');
            break;
            case '03':
            $error = $this->module->l('Communication problems with legacy');
            break;
            case '04':
            $error = $this->module->l('Transaction denied by the circuits');
            break;
            case '06':
            $error = $this->module->l('Service problem');
              break;
            default:
            $error = $this->module->l('System problem');
              break;
    }
    if (!$rfo->getResult()){
            $error = $this->module->l('Request canceled');
        }

        Db::getInstance()->update('pospostepay_payment_verification', array('result'=>'KO'), 'order_id like "'.pSQL($rfo->getOrderId()).'"' );
        
        $this->context->smarty->assign(array(
              'error' => $error,
    ));

        $this->setTemplate('module:pospostepay/views/templates/front/payment_error.tpl');
    }
}
