<?php
/**
 * 2008 - 2019 Presto-Changeo
 *
 * MODULE Paypaladvanced
 *
 * @author    Presto-Changeo <info@presto-changeo.com>
 * @copyright Copyright (c) permanent, Presto-Changeo
 * @license   Addons PrestaShop license limitation
 * @link      http://www.presto-changeo.com
 * @version   1.0.0
 *
 * NOTICE OF LICENSE
 *
 * Don't use this module on several shops. The license provided by PrestaShop Addons
 * for all its modules is valid only once for a single shop.
 *
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class OOSCombinationChange extends Module
{

    protected $html = '';
    protected $postErrors = array();
    protected $full_version = 10000;
    public $cdc_random;

    public function __construct()
    {
        $this->name = 'ooscombinationchange';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';

        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->author = 'Presto-changeo';

        $this->bootstrap = true;
        parent::__construct();

        $this->refreshProperties();

        $this->displayName = $this->l('Out Of Stock Combination Change');
        $this->description = $this->l('Automatically changes the default combination for a product when it goes out of stock');

        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('No currency has been set for this module.');
        }
    }

    public function install()
    {
        $secure_key = md5(mt_rand() . time());

        if (!parent::install() ||
            !$this->registerHook('newOrder')
        ) {
            return false;
        }

        $products = $this->getProductsWithDefaultCombination();

        foreach ($products as $product) {
            $combination = new Combination($product['id_product_attribute']);
            $comb_id = $this->getHighestStockCombinationWithSamePrice($product['id_product'], (float)$combination->price);
            if (!$comb_id) {
                $comb_id = $this->getHighestStockCombination($product['id_product']);
            }
            if($comb_id) {
                $p = new Product($product['id_product']);
                $p->deleteDefaultAttributes();
                $p->setDefaultAttribute($comb_id);
            }
        }

        return true;
    }

    private function refreshProperties()
    {
        $random = Configuration::get('CDC_RANDOM');
        if ($random != '') {
            $this->cdc_random = $random;
        } else {
            $random = md5(mt_rand() . time());
            Configuration::updateValue('CDC_RANDOM', $random);
            $this->cdc_random = $random;
        }

        $this->last_updated = Configuration::get('PRESTO_CHANGEO_UC');
    }

    private function getProductsWithDefaultCombination()
    {
        $result = Db::getInstance()->ExecuteS('
        SELECT p.`id_product`, sa.`id_product_attribute`
        FROM `' . _DB_PREFIX_ . 'product` p
        LEFT JOIN `' . _DB_PREFIX_ . 'stock_available` sa
            ON (sa.`id_product_attribute` = p.`cache_default_attribute`)
        WHERE sa.`id_product_attribute` > 0
        AND sa.`quantity` = 0');

        return $result;
    }

    public function getHighestStockCombinationWithSamePrice($id_product, $price)
    {
        $result = Db::getInstance()->getValue('
        SELECT pa.`id_product_attribute`
        FROM `' . _DB_PREFIX_ . 'product_attribute` pa
        LEFT JOIN `' . _DB_PREFIX_ . 'stock_available` sa
            ON (sa.`id_product_attribute` = pa.`id_product_attribute`)
        WHERE pa.`id_product` = ' . (int) $id_product
        .' AND pa.`price` = '.(float)$price
        .' AND sa.`quantity` = (
            SELECT MAX(sa.`quantity`)
            FROM `' . _DB_PREFIX_ . 'stock_available` sa
            LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute` pa
                ON (pa.`id_product_attribute` = sa.`id_product_attribute`)
            WHERE sa.`id_product` = '.(int)$id_product.'
            AND sa.`id_product_attribute` > 0
            AND pa.`price` = '.(float)$price.'
        )
        AND sa.`quantity` > 0');

        return $result;
    }

    public function getHighestStockCombination($id_product)
    {
        $result = Db::getInstance()->getValue('
        SELECT pa.`id_product_attribute`
        FROM `' . _DB_PREFIX_ . 'product_attribute` pa
        LEFT JOIN `' . _DB_PREFIX_ . 'stock_available` sa
            ON (sa.`id_product_attribute` = pa.`id_product_attribute`)
        WHERE pa.`id_product` = ' . (int) $id_product
        .' AND sa.`quantity` = (
            SELECT MAX(`quantity`)
            FROM `' . _DB_PREFIX_ . 'stock_available`
            WHERE `id_product` = '.(int)$id_product.'
            AND `id_product_attribute` > 0
        )
        AND sa.`quantity` > 0');

        return $result;
    }

    public function hookNewOrder($params) {
        $cart = $params['cart'];
        foreach ($cart->getProducts() as $product) {
            $p = new Product($product['id_product']);
            if (!$p->hasAttributes()) {
                continue;
            }

            $default_attribute = Product::getDefaultAttribute($product['id_product']);
            $qty = StockAvailable::getQuantityAvailableByProduct($product['id_product'], $default_attribute);
            if($qty <= 0) {
                // find the highest stock combination with the same price
                $combination = new Combination($default_attribute);
                $comb_id = $this->getHighestStockCombinationWithSamePrice($product['id_product'], (float)$combination->price);
                if (!$comb_id) {
                    $comb_id = $this->getHighestStockCombination($product['id_product']);
                }
                if($comb_id) {
                    $p->deleteDefaultAttributes();
                    $p->setDefaultAttribute($comb_id);
                }
            }
        }
    }
}
