<?php
/**
 * Copyright 2022 LÍNEA GRÁFICA E.C.E S.L.
 *
 * @author    Línea Gráfica E.C.E. S.L.
 * @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 * @license   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Backward function compatibility
 * Need to be called for each module in 1.4
 */

// Get out if the context is already defined
if (!in_array('Context', get_declared_classes())) {
    require_once(dirname(__FILE__) . '/Context.php');
}

// Get out if the Display (BWDisplay to avoid any conflict)) is already defined
if (!in_array('BWDisplay', get_declared_classes())) {
    require_once(dirname(__FILE__) . '/Display.php');
}

// If not under an object we don't have to set the context
if (!isset($this)) {
    return;
} elseif (isset($this->context)) {
    // If we are under an 1.5 version and backoffice, we have to set some backward variable
    if (_PS_VERSION_ >= '1.5' && isset($this->context->employee->id) && $this->context->employee->id &&
        isset(AdminController::$currentIndex) && !empty(AdminController::$currentIndex)
    ) {
        global $currentIndex;

        $currentIndex = AdminController::$currentIndex;
    }

    return;
}

$this->context = Context::getContext();

$this->smarty = $this->context->smarty;
